//Code Llama-13B DATASET v1.0 Category: Networking ; Style: futuristic
// Futuristic C Networking Example Program

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <unistd.h>

#define PORT 8080
#define MAX_CONNECTIONS 5
#define MAX_BUFFER_SIZE 1024

int main() {
    // Create a socket
    int sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock < 0) {
        perror("Socket creation failed");
        exit(EXIT_FAILURE);
    }

    // Bind the socket to a port
    struct sockaddr_in server_addr = {
        .sin_family = AF_INET,
        .sin_addr.s_addr = INADDR_ANY,
        .sin_port = htons(PORT)
    };
    if (bind(sock, (struct sockaddr*)&server_addr, sizeof(server_addr)) < 0) {
        perror("Bind failed");
        exit(EXIT_FAILURE);
    }

    // Listen for incoming connections
    if (listen(sock, MAX_CONNECTIONS) < 0) {
        perror("Listen failed");
        exit(EXIT_FAILURE);
    }

    printf("Server started on port %d\n", PORT);

    // Accept incoming connections
    struct sockaddr_in client_addr;
    socklen_t client_addr_len = sizeof(client_addr);
    int client_sock = accept(sock, (struct sockaddr*)&client_addr, &client_addr_len);
    if (client_sock < 0) {
        perror("Accept failed");
        exit(EXIT_FAILURE);
    }

    printf("Client connected from %s:%d\n", inet_ntoa(client_addr.sin_addr), ntohs(client_addr.sin_port));

    // Read data from the client
    char buffer[MAX_BUFFER_SIZE];
    int n = read(client_sock, buffer, MAX_BUFFER_SIZE);
    if (n < 0) {
        perror("Read failed");
        exit(EXIT_FAILURE);
    }

    // Print the data
    printf("Client sent: %s\n", buffer);

    // Send data back to the client
    char response[] = "Hello, client!";
    n = write(client_sock, response, strlen(response));
    if (n < 0) {
        perror("Write failed");
        exit(EXIT_FAILURE);
    }

    printf("Response sent to client\n");

    // Close the client connection
    close(client_sock);

    // Close the server socket
    close(sock);

    return EXIT_SUCCESS;
}