//MISTRAL-7B DATASET v1.0 Category: Pattern printing ; Style: unmistakable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>

#define WIDTH 50
#define HEIGHT 10

typedef struct {
    int x;
    int y;
} point;

typedef struct {
    char symbol;
    point start;
    point end;
} pattern;

pattern patterns[] = {
    {'*', {1, 1}, {WIDTH, HEIGHT}},
    {'O', {2, 1}, {WIDTH - 2, HEIGHT - 2}},
    {'#', {3, 1}, {WIDTH - 4, HEIGHT - 4}},
    {'&', {4, 1}, {WIDTH - 6, HEIGHT - 6}},
    {'!', {5, 1}, {WIDTH - 8, HEIGHT - 8}}
};

void print_pattern(pattern p) {
    int i, j;

    for (i = p.start.y; i <= p.end.y; i++) {
        for (j = p.start.x; j <= p.end.x; j++) {
            printf("%c", p.symbol);
            usleep(50000); // Add a delay to make the pattern visible
        }
        printf("\n");
    }
}

int main() {
    int i;

    system("clear"); // For Unix-based systems, use 'cls' for Windows

    for (i = 0; i < sizeof(patterns) / sizeof(pattern); i++) {
        print_pattern(patterns[i]);
    }

    return 0;
}