//Code Llama-13B DATASET v1.0 Category: Building a FTP Client ; Style: satisfied
// Building an FTP Client example program

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <unistd.h>

#define MAX_BUFFER_SIZE 1024

int main(int argc, char *argv[]) {
  int sockfd, n;
  char buffer[MAX_BUFFER_SIZE];
  struct sockaddr_in serv_addr;

  if (argc != 2) {
    fprintf(stderr, "Usage: %s <hostname/IP address>\n", argv[0]);
    exit(1);
  }

  // Create a socket
  sockfd = socket(AF_INET, SOCK_STREAM, 0);
  if (sockfd < 0) {
    perror("ERROR opening socket");
    exit(1);
  }

  // Initialize server address
  memset(&serv_addr, 0, sizeof(serv_addr));
  serv_addr.sin_family = AF_INET;
  serv_addr.sin_port = htons(21);

  // Convert hostname/IP address to binary
  if (inet_pton(AF_INET, argv[1], &serv_addr.sin_addr) <= 0) {
    perror("ERROR converting hostname/IP address");
    exit(1);
  }

  // Connect to server
  if (connect(sockfd, (struct sockaddr *)&serv_addr, sizeof(serv_addr)) < 0) {
    perror("ERROR connecting");
    exit(1);
  }

  // Send FTP command
  if (send(sockfd, "USER anonymous\r\n", strlen("USER anonymous\r\n"), 0) < 0) {
    perror("ERROR sending FTP command");
    exit(1);
  }

  // Read server response
  n = recv(sockfd, buffer, MAX_BUFFER_SIZE, 0);
  if (n < 0) {
    perror("ERROR reading server response");
    exit(1);
  }

  // Print server response
  printf("Server response: %s\n", buffer);

  // Close socket
  close(sockfd);

  return 0;
}