//Falcon-180B DATASET v1.0 Category: Classical Circuit Simulator ; Style: light-weight
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#define MAX_COMPONENTS 100
#define MAX_NODES 100
#define MAX_EDGES 100

typedef struct {
    int node1;
    int node2;
    double resistance;
} Edge;

typedef struct {
    int num_nodes;
    int num_edges;
    Edge edges[MAX_EDGES];
} Circuit;

void add_edge(Circuit* circuit, int node1, int node2, double resistance) {
    Edge edge = {node1, node2, resistance};
    circuit->edges[circuit->num_edges++] = edge;
}

void add_node(Circuit* circuit) {
    circuit->num_nodes++;
}

void print_circuit(Circuit* circuit) {
    printf("Circuit:\n");
    printf("Nodes: %d\n", circuit->num_nodes);
    printf("Edges: %d\n", circuit->num_edges);
    for (int i = 0; i < circuit->num_edges; i++) {
        Edge edge = circuit->edges[i];
        printf("Edge %d: (%d, %d) %lf\n", i + 1, edge.node1, edge.node2, edge.resistance);
    }
}

int main() {
    Circuit circuit = {0, 0};
    add_node(&circuit);
    add_node(&circuit);
    add_edge(&circuit, 0, 1, 10.0);
    add_node(&circuit);
    add_edge(&circuit, 1, 2, 20.0);
    add_edge(&circuit, 2, 0, 30.0);
    print_circuit(&circuit);
    return 0;
}