//LLAMA2-13B DATASET v1.0 Category: Phone Book ; Style: safe
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define PHONE_BOOK_SIZE 100
#define MAX_NAME_LENGTH 25
#define MAX_PHONE_NUMBER_LENGTH 15

typedef struct {
    char name[MAX_NAME_LENGTH];
    char phoneNumber[MAX_PHONE_NUMBER_LENGTH];
} phoneBookEntry;

phoneBookEntry phoneBook[PHONE_BOOK_SIZE];
int currentSize = 0;

void addEntry(char *name, char *phoneNumber) {
    if (currentSize == PHONE_BOOK_SIZE) {
        printf("Phone book is full! Cannot add any more entries.\n");
        return;
    }

    strcpy(phoneBook[currentSize].name, name);
    strcpy(phoneBook[currentSize].phoneNumber, phoneNumber);
    currentSize++;
}

void removeEntry(int index) {
    if (index >= currentSize || index < 0) {
        printf("Invalid index! Cannot remove any entries.\n");
        return;
    }

    strcpy(phoneBook[index].name, "");
    strcpy(phoneBook[index].phoneNumber, "");
    currentSize--;
}

void printEntries() {
    printf("Phone book entries:\n");
    for (int i = 0; i < currentSize; i++) {
        printf("Name: %s, Phone number: %s\n", phoneBook[i].name, phoneBook[i].phoneNumber);
    }
}

int main() {
    srand(time(NULL));

    // Add some entries to the phone book
    addEntry("John Doe", "555-1234");
    addEntry("Jane Doe", "555-5678");
    addEntry("Bob Smith", "555-9012");

    // Remove an entry from the phone book
    removeEntry(1);

    // Print the remaining entries
    printEntries();

    return 0;
}