//Gemma-7B DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: accurate
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_PROCESSES 5
#define MAX_SCHEDULE_SIZE 10

typedef struct Process {
    int process_id;
    int arrival_time;
    int execution_time;
    int waiting_time;
    int turnaround_time;
} Process;

void roundrobin(Process processes[], int num_processes) {
    int current_time = 0;
    int i = 0;
    int completed = 0;

    while (!completed) {
        for (i = 0; i < num_processes; i++) {
            if (processes[i].arrival_time <= current_time && processes[i].execution_time > 0) {
                processes[i].execution_time--;
                processes[i].waiting_time++;
                if (processes[i].execution_time == 0) {
                    completed = 1;
                    processes[i].turnaround_time = current_time - processes[i].arrival_time;
                }
            }
        }

        current_time++;
    }
}

int main() {
    Process processes[MAX_PROCESSES] = {
        {1, 0, 5, 0, 0},
        {2, 2, 4, 0, 0},
        {3, 3, 3, 0, 0},
        {4, 4, 2, 0, 0},
        {5, 5, 6, 0, 0}
    };

    roundrobin(processes, MAX_PROCESSES);

    for (int i = 0; i < MAX_PROCESSES; i++) {
        printf("Process ID: %d, Arrival Time: %d, Execution Time: %d, Waiting Time: %d, Turnaround Time: %d\n", processes[i].process_id, processes[i].arrival_time, processes[i].execution_time, processes[i].waiting_time, processes[i].turnaround_time);
    }

    return 0;
}