//GEMINI-pro DATASET v1.0 Category: Stock market tracker ; Style: puzzling
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the number of stocks to track
#define NUM_STOCKS 5

// Define the structure of a stock
typedef struct {
    char *name;
    float price;
    int quantity;
} Stock;

// Create an array of stocks
Stock stocks[NUM_STOCKS] = {
    {"Apple", 100.00, 100},
    {"Google", 50.00, 200},
    {"Microsoft", 25.00, 300},
    {"Amazon", 10.00, 400},
    {"IBM", 5.00, 500}
};

// Function to print the stock market tracker
void print_stock_market_tracker() {
    // Print the header
    printf("%-15s %-10s %-10s\n", "Name", "Price", "Quantity");

    // Iterate over the stocks
    for (int i = 0; i < NUM_STOCKS; i++) {
        // Print the stock information
        printf("%-15s $%-10.2f %d\n", stocks[i].name, stocks[i].price, stocks[i].quantity);
    }
}

// Function to get the total value of the stocks
float get_total_value() {
    // Initialize the total value
    float total_value = 0.0;

    // Iterate over the stocks
    for (int i = 0; i < NUM_STOCKS; i++) {
        // Add the value of the stock to the total value
        total_value += stocks[i].price * stocks[i].quantity;
    }

    // Return the total value
    return total_value;
}

// Function to get the average price of the stocks
float get_average_price() {
    // Get the total value of the stocks
    float total_value = get_total_value();

    // Get the total quantity of the stocks
    int total_quantity = 0;
    for (int i = 0; i < NUM_STOCKS; i++) {
        total_quantity += stocks[i].quantity;
    }

    // Calculate the average price
    float average_price = total_value / total_quantity;

    // Return the average price
    return average_price;
}

// Function to buy a stock
void buy_stock(char *name, float price, int quantity) {
    // Find the stock by name
    Stock *stock = NULL;
    for (int i = 0; i < NUM_STOCKS; i++) {
        if (strcmp(stocks[i].name, name) == 0) {
            stock = &stocks[i];
            break;
        }
    }

    // Check if the stock was found
    if (stock == NULL) {
        printf("Error: Stock not found\n");
        return;
    }

    // Check if the price is valid
    if (price <= 0.0) {
        printf("Error: Invalid price\n");
        return;
    }

    // Check if the quantity is valid
    if (quantity <= 0) {
        printf("Error: Invalid quantity\n");
        return;
    }

    // Buy the stock
    stock->price = price;
    stock->quantity += quantity;

    // Print the confirmation message
    printf("Bought %d shares of %s at $%.2f\n", quantity, stock->name, stock->price);
}

// Function to sell a stock
void sell_stock(char *name, float price, int quantity) {
    // Find the stock by name
    Stock *stock = NULL;
    for (int i = 0; i < NUM_STOCKS; i++) {
        if (strcmp(stocks[i].name, name) == 0) {
            stock = &stocks[i];
            break;
        }
    }

    // Check if the stock was found
    if (stock == NULL) {
        printf("Error: Stock not found\n");
        return;
    }

    // Check if the price is valid
    if (price <= 0.0) {
        printf("Error: Invalid price\n");
        return;
    }

    // Check if the quantity is valid
    if (quantity <= 0) {
        printf("Error: Invalid quantity\n");
        return;
    }

    // Sell the stock
    stock->price = price;
    stock->quantity -= quantity;

    // Print the confirmation message
    printf("Sold %d shares of %s at $%.2f\n", quantity, stock->name, stock->price);
}

// Main function
int main() {
    // Print the stock market tracker
    print_stock_market_tracker();

    // Get the total value of the stocks
    float total_value = get_total_value();

    // Get the average price of the stocks
    float average_price = get_average_price();

    // Print the total value and average price
    printf("\nTotal value: $%.2f\n", total_value);
    printf("Average price: $%.2f\n\n", average_price);

    // Buy a stock
    buy_stock("Apple", 120.00, 10);

    // Sell a stock
    sell_stock("Microsoft", 30.00, 50);

    // Print the stock market tracker again
    print_stock_market_tracker();

    // Get the total value of the stocks again
    total_value = get_total_value();

    // Get the average price of the stocks again
    average_price = get_average_price();

    // Print the total value and average price again
    printf("\nTotal value: $%.2f\n", total_value);
    printf("Average price: $%.2f\n", average_price);

    return 0;
}