//GEMINI-pro DATASET v1.0 Category: Packet Capturer with pcap library ; Style: shape shifting
#include <stdio.h>
#include <stdlib.h>
#include <pcap.h>
#include <stdbool.h>
#include <string.h>
#include <arpa/inet.h>

// The callback function to be called for each received packet.
void got_packet(u_char *user, const struct pcap_pkthdr *header, const u_char *packet) {
    // Extract data from the packet.
    struct in_addr src_ip;
    struct in_addr dst_ip;
    u_int16_t src_port;
    u_int16_t dst_port;
    char src_ip_str[INET_ADDRSTRLEN];
    char dst_ip_str[INET_ADDRSTRLEN];
    memcpy(&src_ip, packet + 12, sizeof(src_ip));
    memcpy(&dst_ip, packet + 16, sizeof(dst_ip));
    src_port = ntohs(*(u_int16_t *)(packet + 20));
    dst_port = ntohs(*(u_int16_t *)(packet + 22));
    inet_ntop(AF_INET, &src_ip, src_ip_str, INET_ADDRSTRLEN);
    inet_ntop(AF_INET, &dst_ip, dst_ip_str, INET_ADDRSTRLEN);

    // Print the packet data.
    printf("Received a packet from %s:%hu to %s:%hu\n", src_ip_str, src_port, dst_ip_str, dst_port);
}

int main() {
    // Open a live packet capture device.
    char *device = pcap_lookupdev(NULL);
    if (device == NULL) {
        perror("pcap_lookupdev");
        return EXIT_FAILURE;
    }
    pcap_t *handle = pcap_open_live(device, 65535, 1, 1000, NULL);
    if (handle == NULL) {
        perror("pcap_open_live");
        return EXIT_FAILURE;
    }

    // Set the filter expression.
    struct bpf_program filter;
    if (pcap_compile(handle, &filter, "tcp", 1, 0) == -1) {
        perror("pcap_compile");
        return EXIT_FAILURE;
    }
    if (pcap_setfilter(handle, &filter) == -1) {
        perror("pcap_setfilter");
        return EXIT_FAILURE;
    }

    // Start the packet capture loop.
    pcap_loop(handle, -1, got_packet, NULL);

    // Close  the packet capture device.
    pcap_close(handle);
    return EXIT_SUCCESS;
}