//GEMINI-pro DATASET v1.0 Category: Basic Image Processing: Simple tasks like flipping an image, changing brightness/contrast ; Style: thoughtful
#include <stdio.h>
#include <stdlib.h>

// Image dimensions
#define WIDTH 3
#define HEIGHT 3

// Pixel values
#define BLACK 0
#define WHITE 255

// Image data
unsigned char image[WIDTH * HEIGHT];

// Function to flip the image horizontally
void flip_horizontal() {
    for (int i = 0; i < HEIGHT; i++) {
        for (int j = 0; j < WIDTH / 2; j++) {
            unsigned char temp = image[i * WIDTH + j];
            image[i * WIDTH + j] = image[i * WIDTH + WIDTH - j - 1];
            image[i * WIDTH + WIDTH - j - 1] = temp;
        }
    }
}

// Function to flip the image vertically
void flip_vertical() {
    for (int i = 0; i < HEIGHT / 2; i++) {
        for (int j = 0; j < WIDTH; j++) {
            unsigned char temp = image[i * WIDTH + j];
            image[i * WIDTH + j] = image[(HEIGHT - i - 1) * WIDTH + j];
            image[(HEIGHT - i - 1) * WIDTH + j] = temp;
        }
    }
}

// Function to change the brightness of the image
void change_brightness(int brightness) {
    for (int i = 0; i < WIDTH * HEIGHT; i++) {
        image[i] = image[i] + brightness;
        if (image[i] > WHITE) {
            image[i] = WHITE;
        } else if (image[i] < BLACK) {
            image[i] = BLACK;
        }
    }
}

// Function to change the contrast of the image
void change_contrast(int contrast) {
    for (int i = 0; i < WIDTH * HEIGHT; i++) {
        image[i] = (image[i] - 128) * contrast + 128;
        if (image[i] > WHITE) {
            image[i] = WHITE;
        } else if (image[i] < BLACK) {
            image[i] = BLACK;
        }
    }
}

// Function to print the image
void print_image() {
    for (int i = 0; i < HEIGHT; i++) {
        for (int j = 0; j < WIDTH; j++) {
            printf("%d ", image[i * WIDTH + j]);
        }
        printf("\n");
    }
}

int main() {
    // Initialize the image with a checkerboard pattern
    for (int i = 0; i < HEIGHT; i++) {
        for (int j = 0; j < WIDTH; j++) {
            if ((i + j) % 2 == 0) {
                image[i * WIDTH + j] = BLACK;
            } else {
                image[i * WIDTH + j] = WHITE;
            }
        }
    }

    // Flip the image horizontally
    flip_horizontal();

    // Flip the image vertically
    flip_vertical();

    // Change the brightness of the image
    change_brightness(50);

    // Change the contrast of the image
    change_contrast(2);

    // Print the image
    print_image();

    return 0;
}