//Code Llama-13B DATASET v1.0 Category: Building a JSON Parser ; Style: grateful
/// Building a JSON Parser in a Grateful Style

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

// Define a structure to store the JSON data
struct JSONData {
  char* key;
  char* value;
};

// Function to parse a JSON string
void parseJSON(char* json, struct JSONData* data) {
  // Initialize the data structure
  data->key = NULL;
  data->value = NULL;

  // Loop through the JSON string
  for (int i = 0; json[i] != '\0'; i++) {
    // Check if the current character is a quotation mark
    if (json[i] == '\"') {
      // If it is, check if it is a key or value
      if (data->key == NULL) {
        // If it is a key, set the key
        data->key = json + i + 1;
      } else {
        // If it is a value, set the value
        data->value = json + i + 1;
      }
    }
  }
}

// Function to print the parsed JSON data
void printJSON(struct JSONData* data) {
  printf("{");
  printf("\"%s\": \"%s\"", data->key, data->value);
  printf("}\n");
}

int main() {
  // Define a JSON string
  char* json = "{\"name\": \"John\", \"age\": 30}";

  // Parse the JSON string
  struct JSONData data;
  parseJSON(json, &data);

  // Print the parsed JSON data
  printJSON(&data);

  return 0;
}