//Falcon-180B DATASET v1.0 Category: Word Count Tool ; Style: unmistakable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_WORDS 1000000
#define MAX_WORD_LENGTH 100

typedef struct {
    char *word;
    int count;
} WordCount;

int compareWords(const void *a, const void *b) {
    WordCount *wordA = (WordCount *)a;
    WordCount *wordB = (WordCount *)b;

    if (wordA->count > wordB->count) {
        return -1;
    } else if (wordA->count < wordB->count) {
        return 1;
    } else {
        return 0;
    }
}

void printWordCounts(WordCount *wordCounts, int numWords) {
    qsort(wordCounts, numWords, sizeof(WordCount), compareWords);

    for (int i = 0; i < numWords; i++) {
        WordCount *word = &wordCounts[i];
        printf("%s: %d\n", word->word, word->count);
    }
}

int main() {
    char *text = NULL;
    size_t textSize = 0;
    WordCount *wordCounts = NULL;
    int numWords = 0;

    printf("Enter text to count words:\n");
    if (getline(&text, &textSize, stdin) == -1) {
        printf("Error reading input.\n");
        exit(1);
    }

    char *word = strtok(text, ",.?!;:\"'");
    while (word!= NULL) {
        WordCount *existingWord = NULL;
        for (int i = 0; i < numWords; i++) {
            if (strcmp(word, wordCounts[i].word) == 0) {
                existingWord = &wordCounts[i];
                break;
            }
        }

        if (existingWord == NULL) {
            if (numWords >= MAX_WORDS) {
                printf("Maximum number of words reached.\n");
                exit(1);
            }

            existingWord = &wordCounts[numWords];
            numWords++;
        }

        existingWord->count++;
        word = strtok(NULL, ",.?!;:\"'");
    }

    printWordCounts(wordCounts, numWords);

    free(text);
    free(wordCounts);

    return 0;
}