//Gemma-7B DATASET v1.0 Category: Network Ping Test ; Style: light-weight
#include <stdio.h>
#include <netdb.h>
#include <sys/socket.h>
#include <unistd.h>
#include <stdlib.h>

int main() {
    int sockfd, n, port = 53001, i, status;
    struct sockaddr_in servaddr;
    char ping_msg[] = "PING!";
    char recv_msg[256];

    // Create a socket
    sockfd = socket(AF_INET, SOCK_STREAM, htons(port));
    if (sockfd < 0) {
        perror("Error creating socket");
        exit(1);
    }

    // Set up the server address
    servaddr.sin_family = AF_INET;
    servaddr.sin_port = htons(port);
    servaddr.sin_addr.s_addr = inet_addr("192.168.1.10");

    // Connect to the server
    if (connect(sockfd, (struct sockaddr *)&servaddr, sizeof(servaddr)) < 0) {
        perror("Error connecting to server");
        exit(1);
    }

    // Send the ping message
    n = send(sockfd, ping_msg, sizeof(ping_msg), 0);
    if (n < 0) {
        perror("Error sending ping message");
        exit(1);
    }

    // Receive the reply message
    n = recv(sockfd, recv_msg, sizeof(recv_msg), 0);
    if (n < 0) {
        perror("Error receiving reply message");
        exit(1);
    }

    // Print the reply message
    printf("Received: %s\n", recv_msg);

    // Close the socket
    close(sockfd);

    return 0;
}