//Falcon-180B DATASET v1.0 Category: Threading Library Implementation ; Style: accurate
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>

#define NUM_THREADS 5

typedef struct {
    int id;
    char name[20];
} thread_data_t;

void *thread_function(void *arg) {
    thread_data_t *data = (thread_data_t *) arg;

    printf("Thread %d started with name %s\n", data->id, data->name);
    sleep(1);
    printf("Thread %d finished\n", data->id);

    return NULL;
}

int main() {
    pthread_t threads[NUM_THREADS];
    int rc;
    int i;

    thread_data_t data[NUM_THREADS];

    for (i = 0; i < NUM_THREADS; i++) {
        sprintf(data[i].name, "Thread %d", i + 1);
        data[i].id = i + 1;
    }

    for (i = 0; i < NUM_THREADS; i++) {
        rc = pthread_create(&threads[i], NULL, thread_function, (void *) &data[i]);
        if (rc) {
            printf("Error: unable to create thread, %d\n", rc);
            exit(-1);
        }
    }

    for (i = 0; i < NUM_THREADS; i++) {
        rc = pthread_join(threads[i], NULL);
        if (rc) {
            printf("Error: unable to join with thread, %d\n", rc);
            exit(-1);
        }
    }

    return 0;
}