//Falcon-180B DATASET v1.0 Category: Warehouse Management System ; Style: excited
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_PRODUCTS 1000
#define MAX_LOCATIONS 100
#define MAX_ORDERS 1000

typedef struct {
    char name[50];
    int quantity;
    int location;
} Product;

typedef struct {
    int id;
    int quantity;
    int location;
} Order;

Product products[MAX_PRODUCTS];
Order orders[MAX_ORDERS];
int num_products = 0;
int num_orders = 0;

void addProduct(char* name, int quantity, int location) {
    strcpy(products[num_products].name, name);
    products[num_products].quantity = quantity;
    products[num_products].location = location;
    num_products++;
}

void addOrder(int id, int quantity, int location) {
    orders[num_orders].id = id;
    orders[num_orders].quantity = quantity;
    orders[num_orders].location = location;
    num_orders++;
}

void printProducts() {
    printf("Product Name\tQuantity\tLocation\n");
    for (int i = 0; i < num_products; i++) {
        printf("%s\t%d\t%d\n", products[i].name, products[i].quantity, products[i].location);
    }
}

void printOrders() {
    printf("Order ID\tQuantity\tLocation\n");
    for (int i = 0; i < num_orders; i++) {
        printf("%d\t%d\t%d\n", orders[i].id, orders[i].quantity, orders[i].location);
    }
}

int main() {
    addProduct("iPhone", 100, 1);
    addProduct("Samsung Galaxy", 50, 2);
    addProduct("MacBook", 25, 3);

    addOrder(1, 10, 4);
    addOrder(2, 20, 5);
    addOrder(3, 30, 6);

    printProducts();
    printOrders();

    return 0;
}