//Gemma-7B DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: excited
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_PROCESS 5
#define MAX_TIME 10

typedef struct Process {
    int id;
    int arrivalTime;
    int burstTime;
    int completionTime;
} Process;

void roundRobin(Process processes[]) {
    int currentTime = 0;
    int i = 0;
    int quantum = 2;

    while (!processes[i].completionTime) {
        if (processes[i].arrivalTime <= currentTime) {
            processes[i].completionTime = currentTime + processes[i].burstTime;
            printf("Process %d completed at time %d\n", processes[i].id, processes[i].completionTime);
            i = (i + 1) % MAX_PROCESS;
        } else {
            currentTime++;
        }
    }
}

int main() {
    Process processes[MAX_PROCESS];

    // Create processes
    processes[0].id = 1;
    processes[0].arrivalTime = 0;
    processes[0].burstTime = 5;

    processes[1].id = 2;
    processes[1].arrivalTime = 2;
    processes[1].burstTime = 4;

    processes[2].id = 3;
    processes[2].arrivalTime = 4;
    processes[2].burstTime = 3;

    processes[3].id = 4;
    processes[3].arrivalTime = 6;
    processes[3].burstTime = 2;

    processes[4].id = 5;
    processes[4].arrivalTime = 8;
    processes[4].burstTime = 4;

    roundRobin(processes);

    return 0;
}