//GEMINI-pro DATASET v1.0 Category: Appointment Scheduler ; Style: expert-level
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_APPOINTMENTS 100

typedef struct {
    char name[50];
    char description[200];
    int start_time;
    int end_time;
} appointment_t;

appointment_t appointments[MAX_APPOINTMENTS];
int num_appointments = 0;

void add_appointment(char *name, char *description, int start_time, int end_time) {
    if (num_appointments >= MAX_APPOINTMENTS) {
        printf("Error: Appointment schedule is full.\n");
        return;
    }

    strcpy(appointments[num_appointments].name, name);
    strcpy(appointments[num_appointments].description, description);
    appointments[num_appointments].start_time = start_time;
    appointments[num_appointments].end_time = end_time;
    num_appointments++;
}

void print_appointments() {
    for (int i = 0; i < num_appointments; i++) {
        printf("%s: %s (%d-%d)\n", appointments[i].name, appointments[i].description, appointments[i].start_time, appointments[i].end_time);
    }
}

void sort_appointments() {
    for (int i = 0; i < num_appointments - 1; i++) {
        for (int j = i + 1; j < num_appointments; j++) {
            if (appointments[i].start_time > appointments[j].start_time) {
                appointment_t temp = appointments[i];
                appointments[i] = appointments[j];
                appointments[j] = temp;
            }
        }
    }
}

int main() {
    add_appointment("Meeting with John", "Discuss project plans", 1000, 1100);
    add_appointment("Lunch with Mary", "Catch up on the latest news", 1200, 1300);
    add_appointment("Doctor's appointment", "Annual checkup", 1400, 1500);

    sort_appointments();

    print_appointments();

    return 0;
}