//GEMINI-pro DATASET v1.0 Category: Client Server Application ; Style: future-proof
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <unistd.h>

struct sockaddr_un addr;
int sockfd;

void client() {
  if ((sockfd = socket(AF_UNIX, SOCK_STREAM, 0)) == -1) {
    perror("socket");
    exit(1);
  }
  memset(&addr, 0, sizeof(addr));
  addr.sun_family = AF_UNIX;
  strcpy(addr.sun_path, "server.sock");
  if (connect(sockfd, (struct sockaddr *)&addr, sizeof(addr)) == -1) {
    perror("connect");
    exit(1);
  }
  char *message = "Hello from client";
  if (send(sockfd, message, strlen(message), 0) == -1) {
    perror("send");
    exit(1);
  }
  char buffer[1024];
  if (recv(sockfd, buffer, sizeof(buffer), 0) == -1) {
    perror("recv");
    exit(1);
  }
  printf("Received from server: %s\n", buffer);
  close(sockfd);
}

void server() {
  if ((sockfd = socket(AF_UNIX, SOCK_STREAM, 0)) == -1) {
    perror("socket");
    exit(1);
  }
  memset(&addr, 0, sizeof(addr));
  addr.sun_family = AF_UNIX;
  strcpy(addr.sun_path, "server.sock");
  if (bind(sockfd, (struct sockaddr *)&addr, sizeof(addr)) == -1) {
    perror("bind");
    exit(1);
  }
  if (listen(sockfd, 5) == -1) {
    perror("listen");
    exit(1);
  }
  int client_sockfd;
  struct sockaddr_un client_addr;
  socklen_t client_addr_len = sizeof(client_addr);
  if ((client_sockfd = accept(sockfd, (struct sockaddr *)&client_addr,
                              &client_addr_len)) == -1) {
    perror("accept");
    exit(1);
  }
  char buffer[1024];
  if (recv(client_sockfd, buffer, sizeof(buffer), 0) == -1) {
    perror("recv");
    exit(1);
  }
  printf("Received from client: %s\n", buffer);
  char *message = "Hello from server";
  if (send(client_sockfd, message, strlen(message), 0) == -1) {
    perror("send");
    exit(1);
  }
  close(client_sockfd);
}

int main() {
  if (fork() == 0) {
    client();
  } else {
    server();
  }
  return 0;
}