//Falcon-180B DATASET v1.0 Category: Bitwise operations ; Style: scientific
#include <stdio.h>
#include <stdlib.h>

// Function to count the number of set bits in an integer
int count_bits(unsigned int num) {
    int count = 0;
    while (num) {
        if (num & 1) {
            count++;
        }
        num >>= 1;
    }
    return count;
}

// Function to reverse the bits of an integer
unsigned int reverse_bits(unsigned int num) {
    unsigned int reversed = 0;
    int i = 0;
    while (num) {
        reversed |= (num & 1) << i;
        num >>= 1;
        i++;
    }
    return reversed;
}

// Function to set the nth bit of an integer to 1
void set_bit(unsigned int *num, int n) {
    *num |= (1 << n);
}

// Function to clear the nth bit of an integer to 0
void clear_bit(unsigned int *num, int n) {
    *num &= ~(1 << n);
}

// Function to toggle the nth bit of an integer
void toggle_bit(unsigned int *num, int n) {
    *num ^= (1 << n);
}

int main() {
    unsigned int num1 = 0b10101010;
    unsigned int num2 = 0b01010101;

    // Count the number of set bits in num1 and num2
    int num1_bits = count_bits(num1);
    int num2_bits = count_bits(num2);

    printf("Number of set bits in %u: %d\n", num1, num1_bits);
    printf("Number of set bits in %u: %d\n", num2, num2_bits);

    // Reverse the bits of num1 and num2
    unsigned int reversed_num1 = reverse_bits(num1);
    unsigned int reversed_num2 = reverse_bits(num2);

    printf("Reversed bits of %u: %u\n", num1, reversed_num1);
    printf("Reversed bits of %u: %u\n", num2, reversed_num2);

    // Set the nth bit of num1 and num2
    set_bit(&num1, 3);
    set_bit(&num2, 5);

    printf("After setting the 3rd bit of %u: %u\n", num1, num1);
    printf("After setting the 5th bit of %u: %u\n", num2, num2);

    // Clear the nth bit of num1 and num2
    clear_bit(&num1, 2);
    clear_bit(&num2, 4);

    printf("After clearing the 2nd bit of %u: %u\n", num1, num1);
    printf("After clearing the 4th bit of %u: %u\n", num2, num2);

    // Toggle the nth bit of num1 and num2
    toggle_bit(&num1, 1);
    toggle_bit(&num2, 6);

    printf("After toggling the 1st bit of %u: %u\n", num1, num1);
    printf("After toggling the 6th bit of %u: %u\n", num2, num2);

    return 0;
}