//Falcon2-11B DATASET v1.0 Category: Matrix operations ; Style: asynchronous
#include <stdio.h>

// Function to add two matrices
void add_matrices(int a[3][3], int b[3][3], int c[3][3]) {
    for (int i = 0; i < 3; i++) {
        for (int j = 0; j < 3; j++) {
            c[i][j] = a[i][j] + b[i][j];
        }
    }
}

// Function to multiply two matrices
void multiply_matrices(int a[3][3], int b[3][3], int c[3][3]) {
    for (int i = 0; i < 3; i++) {
        for (int j = 0; j < 3; j++) {
            c[i][j] = 0;
            for (int k = 0; k < 3; k++) {
                c[i][j] += a[i][k] * b[k][j];
            }
        }
    }
}

// Function to transpose a matrix
void transpose_matrix(int a[3][3], int b[3][3]) {
    for (int i = 0; i < 3; i++) {
        for (int j = 0; j < 3; j++) {
            int temp = b[i][j];
            b[i][j] = b[j][i];
            b[j][i] = temp;
        }
    }
}

int main() {
    int a[3][3] = {{1, 2, 3}, {4, 5, 6}, {7, 8, 9}};
    int b[3][3] = {{9, 8, 7}, {6, 5, 4}, {3, 2, 1}};
    int c[3][3] = {{0, 0, 0}, {0, 0, 0}, {0, 0, 0}};
    int d[3][3] = {{0, 0, 0}, {0, 0, 0}, {0, 0, 0}};
    int e[3][3] = {{0, 0, 0}, {0, 0, 0}, {0, 0, 0}};

    add_matrices(a, b, c);
    multiply_matrices(a, b, d);
    transpose_matrix(d, e);

    printf("Matrix C:\n");
    for (int i = 0; i < 3; i++) {
        for (int j = 0; j < 3; j++) {
            printf("%d ", c[i][j]);
        }
        printf("\n");
    }

    printf("Matrix D:\n");
    for (int i = 0; i < 3; i++) {
        for (int j = 0; j < 3; j++) {
            printf("%d ", d[i][j]);
        }
        printf("\n");
    }

    printf("Matrix E:\n");
    for (int i = 0; i < 3; i++) {
        for (int j = 0; j < 3; j++) {
            printf("%d ", e[i][j]);
        }
        printf("\n");
    }

    return 0;
}