//Falcon-180B DATASET v1.0 Category: Bitwise operations ; Style: intelligent
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>

// Function to print binary representation of a number
void printBinary(unsigned int num) {
    int i = 0;
    while (num > 0) {
        printf("%d", num & 1);
        num >>= 1;
        i++;
        if (i == 8) {
            printf("\n");
            i = 0;
        }
    }
}

// Function to check if a number is a power of 2
bool isPowerOfTwo(unsigned int num) {
    if (num <= 0)
        return false;
    while (num % 2 == 0) {
        num /= 2;
    }
    return num == 1;
}

// Function to count the number of set bits in a number
int countSetBits(unsigned int num) {
    int count = 0;
    while (num > 0) {
        count += num & 1;
        num >>= 1;
    }
    return count;
}

int main() {
    // Example usage of functions
    unsigned int num1 = 15;
    printf("Binary representation of %d: ", num1);
    printBinary(num1);
    printf("\n");

    if (isPowerOfTwo(num1))
        printf("%d is a power of 2.\n", num1);
    else
        printf("%d is not a power of 2.\n", num1);

    int num2 = 26;
    printf("Number of set bits in %d: %d\n", num2, countSetBits(num2));

    return 0;
}