//GPT-4o-mini DATASET v1.0 Category: Alien Invasion Probability Calculator ; Style: real-life
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_FACTORS 5

// Structure to hold parameters affecting the probability of an alien invasion
typedef struct {
    char name[100];
    float weight;
    float influenceValue;
} Factor;

// Function prototypes
void initializeFactors(Factor factors[], int *size);
float calculateProbability(Factor factors[], int size);
void displayFactors(Factor factors[], int size);

int main() {
    Factor factors[MAX_FACTORS];
    int size = 0;
    float probability;

    // Initialize random number generator
    srand(time(NULL));

    // Initialize factors affecting alien invasion probability
    initializeFactors(factors, &size);

    // Display the factors and their current influence values
    printf("Factors Affecting Alien Invasion Probability:\n");
    displayFactors(factors, size);

    // Calculate the probability based on user-defined influence values
    probability = calculateProbability(factors, size);

    // Display calculated probability
    printf("Calculating alien invasion probability...\n");
    printf("Overall Probability of Alien Invasion: %.2f%%\n", probability);

    return 0;
}

// Function to initialize factors
void initializeFactors(Factor factors[], int *size) {
    // Sample factors affecting alien invasion, including weights
    strcpy(factors[(*size)++].name, "Technological Advancement");
    factors[*size - 1].weight = 0.35; // Weight of this factor in overall probability
    
    strcpy(factors[(*size)++].name, "Global Population");
    factors[*size - 1].weight = 0.30; 

    strcpy(factors[(*size)++].name, "Environmental Conditions");
    factors[*size - 1].weight = 0.15;

    strcpy(factors[(*size)++].name, "Space Exploration Progress");
    factors[*size - 1].weight = 0.10;

    strcpy(factors[(*size)++].name, "Recent UFO Sightings");
    factors[*size - 1].weight = 0.10;

    // Set random influence values for each factor
    for (int i = 0; i < *size; i++) {
        factors[i].influenceValue = ((float)(rand() % 101)) / 100; // Random value between 0 and 1
    }
}

// Function to calculate overall probability
float calculateProbability(Factor factors[], int size) {
    float totalProbability = 0.0;

    // Calculate weighted probability for each factor
    for (int i = 0; i < size; i++) {
        totalProbability += factors[i].weight * factors[i].influenceValue;
    }

    return totalProbability * 100; // Convert to percentage
}

// Function to display factors and their influence values
void displayFactors(Factor factors[], int size) {
    for (int i = 0; i < size; i++) {
        printf("%s: Influence Value = %.2f (Weight = %.2f)\n",
               factors[i].name, factors[i].influenceValue, factors[i].weight);
    }
}