//MISTRAL-7B DATASET v1.0 Category: Warehouse Management System ; Style: Linus Torvalds
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_PRODUCTS 100
#define MAX_WAREHOUSE 10

struct product {
    char name[50];
    int stock;
};

struct warehouse {
    struct product products[MAX_PRODUCTS];
    int capacity;
    int current_stock;
};

void init_warehouse(struct warehouse *warehouse, int capacity) {
    warehouse->capacity = capacity;
    warehouse->current_stock = 0;
}

int add_product(struct warehouse *warehouse, struct product product) {
    if (warehouse->current_stock + product.stock > warehouse->capacity) {
        return -1;
    }
    strcpy(warehouse->products[warehouse->current_stock].name, product.name);
    warehouse->products[warehouse->current_stock++].stock = product.stock;
    return 0;
}

void print_warehouse(struct warehouse warehouse) {
    printf("Warehouse Status:\n");
    printf("------------------\n");
    for (int i = 0; i < warehouse.current_stock; i++) {
        printf("%d. %s: %d\n", i + 1, warehouse.products[i].name, warehouse.products[i].stock);
    }
}

int main() {
    struct warehouse warehouse;
    init_warehouse(&warehouse, MAX_WAREHOUSE);

    struct product p1 = {"Apple", 50};
    struct product p2 = {"Banana", 30};
    struct product p3 = {"Orange", 20};

    add_product(&warehouse, p1);
    add_product(&warehouse, p2);
    add_product(&warehouse, p3);

    print_warehouse(warehouse);

    return 0;
}