//Gemma-7B DATASET v1.0 Category: Traffic Flow Simulation ; Style: realistic
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_CARS 10
#define MAX_LANE 3

typedef struct Car
{
    int lane;
    int position;
    int speed;
    int direction;
} Car;

void simulateTrafficFlow(Car cars[], int numCars)
{
    int i;
    for (i = 0; i < numCars; i++)
    {
        switch (cars[i].direction)
        {
            case 1:
                cars[i].position++;
                break;
            case -1:
                cars[i].position--;
                break;
        }

        if (cars[i].position >= MAX_LANE)
        {
            cars[i].direction = -1;
        }
        else if (cars[i].position <= 0)
        {
            cars[i].direction = 1;
        }
    }
}

int main()
{
    srand(time(NULL));

    Car cars[MAX_CARS];
    for (int i = 0; i < MAX_CARS; i++)
    {
        cars[i].lane = rand() % MAX_LANE;
        cars[i].position = rand() % MAX_LANE;
        cars[i].speed = rand() % 10;
        cars[i].direction = rand() % 2;
    }

    simulateTrafficFlow(cars, MAX_CARS);

    for (int i = 0; i < MAX_CARS; i++)
    {
        printf("Car %d: Lane %d, Position %d, Speed %d, Direction %d\n", i, cars[i].lane, cars[i].position, cars[i].speed, cars[i].direction);
    }

    return 0;
}