//MISTRAL-7B DATASET v1.0 Category: Interprocess communication ; Style: peaceful
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>

#define FIFO_NAME "myfifo"

void write_to_pipe(char* message) {
    int fd;

    if ((fd = open(FIFO_NAME, O_WRONLY)) < 0) {
        perror("Failed to open pipe for writing");
        exit(EXIT_FAILURE);
    }

    if (write(fd, message, strlen(message)) < 0) {
        perror("Failed to write to pipe");
        exit(EXIT_FAILURE);
    }

    if (close(fd) < 0) {
        perror("Failed to close pipe");
        exit(EXIT_FAILURE);
    }

    printf("Message: %s sent to pipe.\n", message);
}

void read_from_pipe() {
    char buffer[1024];
    int fd;

    if ((fd = open(FIFO_NAME, O_RDONLY)) < 0) {
        perror("Failed to open pipe for reading");
        exit(EXIT_FAILURE);
    }

    if (read(fd, buffer, sizeof(buffer)) < 0) {
        perror("Failed to read from pipe");
        exit(EXIT_FAILURE);
    }

    printf("Message: %s received from pipe.\n", buffer);

    if (close(fd) < 0) {
        perror("Failed to close pipe");
        exit(EXIT_FAILURE);
    }
}

int main() {
    mkfifo(FIFO_NAME, 0666);

    printf("Parent process creating pipe '%s'\n", FIFO_NAME);

    pid_t pid = fork();

    if (pid < 0) {
        perror("Failed to fork");
        exit(EXIT_FAILURE);
    }

    if (pid > 0) {
        write_to_pipe("Hello, Child!");
        unlink(FIFO_NAME);
        printf("Parent process sent message and removed pipe.\n");
        exit(EXIT_SUCCESS);
    }

    read_from_pipe();
    exit(EXIT_SUCCESS);
}