//Falcon-180B DATASET v1.0 Category: Bitwise operations ; Style: Claude Shannon
#include <stdio.h>
#include <stdlib.h>

#define BITS_IN_BYTE 8

void print_binary(unsigned char c)
{
    for (int i = BITS_IN_BYTE - 1; i >= 0; i--)
    {
        printf("%d", (c >> i) & 1);
    }
}

int main()
{
    unsigned char a = 0b10101010;
    unsigned char b = 0b01010101;
    unsigned char c = 0;

    // Bitwise OR operation
    c = a | b;
    printf("Bitwise OR: ");
    print_binary(a);
    printf(" OR ");
    print_binary(b);
    printf(" = ");
    print_binary(c);
    printf("\n");

    // Bitwise AND operation
    c = a & b;
    printf("Bitwise AND: ");
    print_binary(a);
    printf(" AND ");
    print_binary(b);
    printf(" = ");
    print_binary(c);
    printf("\n");

    // Bitwise XOR operation
    c = a ^ b;
    printf("Bitwise XOR: ");
    print_binary(a);
    printf(" XOR ");
    print_binary(b);
    printf(" = ");
    print_binary(c);
    printf("\n");

    // Bitwise NOT operation
    c = ~a;
    printf("Bitwise NOT: ");
    print_binary(a);
    printf(" = ");
    print_binary(c);
    printf("\n");

    // Left shift operation
    c = a << 2;
    printf("Left shift by 2: ");
    print_binary(a);
    printf(" << 2 = ");
    print_binary(c);
    printf("\n");

    // Right shift operation
    c = a >> 2;
    printf("Right shift by 2: ");
    print_binary(a);
    printf(" >> 2 = ");
    print_binary(c);
    printf("\n");

    return 0;
}