//LLAMA2-13B DATASET v1.0 Category: Unit converter ; Style: complex
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#define UNIT_CONVERTER_MAX_LENGTH 2048
#define UNIT_CONVERTER_BUFFER_SIZE 1024

typedef struct unit_converter_t {
    char *name;
    char *symbol;
    double conversion_factor;
} unit_converter_t;

static unit_converter_t unit_converters[] = {
    {"meter", 'm', 1.0},
    {"kilometer", 'km', 1000.0},
    {"centimeter", 'cm', 0.01},
    {"millimeter", 'mm', 0.001},
    {"inch", 'in', 0.0254},
    {"foot", 'ft', 0.3048},
    {"yard", 'yd', 0.9144},
    {"mile", 'mi', 1609.344},
    {"liter", 'L', 1000.0},
    {"gallon", 'gal', 3.785},
    {"fluid_ounce", 'fl oz', 0.02366},
    {"cup", 'c', 0.2366},
    {"pint", 'pt', 0.4736},
    {"gallon", 'gal', 3.785},
    {"ounce", 'oz', 0.02835},
    {"pound", 'lb', 0.453592}
};

static int unit_converter_count = sizeof(unit_converters) / sizeof(unit_converters[0]);

void unit_converter_init(void) {
    int i;

    for (i = 0; i < unit_converter_count; i++) {
        unit_converters[i].conversion_factor = 1.0;
    }
}

void unit_converter_set_conversion_factor(const char *unit, double factor) {
    int i;

    for (i = 0; i < unit_converter_count; i++) {
        if (strcmp(unit, unit_converters[i].name) == 0) {
            unit_converters[i].conversion_factor = factor;
            break;
        }
    }
}

void unit_converter_convert(double value, const char *from_unit, const char *to_unit) {
    int from_index = -1;
    int to_index = -1;

    for (int i = 0; i < unit_converter_count; i++) {
        if (strcmp(from_unit, unit_converters[i].name) == 0) {
            from_index = i;
            break;
        }
    }

    for (int j = 0; j < unit_converter_count; j++) {
        if (strcmp(to_unit, unit_converters[j].name) == 0) {
            to_index = j;
            break;
        }
    }

    if (from_index == -1 || to_index == -1) {
        printf("Invalid unit: %s to %s\n", from_unit, to_unit);
        return;
    }

    double conversion_factor = unit_converters[from_index].conversion_factor;

    if (from_unit == to_unit) {
        printf("No conversion needed: %f %s\n", value, from_unit);
        return;
    }

    value *= conversion_factor;
    printf("%f %s = %f %s\n", value, from_unit, value, to_unit);
}

int main(void) {
    unit_converter_init();

    double value = 5.0;

    unit_converter_convert(value, "meter", "kilometer");
    unit_converter_convert(value, "kilometer", "meter");

    unit_converter_convert(value, "centimeter", "inch");
    unit_converter_convert(value, "inch", "centimeter");

    unit_converter_convert(value, "fluid_ounce", "cup");
    unit_converter_convert(value, "cup", "fluid_ounce");

    return 0;
}