//Falcon-180B DATASET v1.0 Category: Bitwise operations ; Style: authentic
#include <stdio.h>
#include <stdlib.h>

// Function to swap two numbers without using a temporary variable
void swap(int* a, int* b) {
    *a ^= *b;
    *b ^= *a;
    *a ^= *b;
}

// Function to reverse a string using bitwise operations
void reverse_string(char* str) {
    int len = strlen(str);
    for(int i = 0; i < len/2; i++) {
        char temp = str[i];
        str[i] = str[len-i-1];
        str[len-i-1] = temp;
    }
}

int main() {
    int num1 = 10;
    int num2 = 20;

    // Bitwise AND operation
    int result1 = num1 & num2;
    printf("Result of bitwise AND operation: %d\n", result1);

    // Bitwise OR operation
    int result2 = num1 | num2;
    printf("Result of bitwise OR operation: %d\n", result2);

    // Bitwise XOR operation
    int result3 = num1 ^ num2;
    printf("Result of bitwise XOR operation: %d\n", result3);

    // Bitwise NOT operation
    int result4 = ~num1;
    printf("Result of bitwise NOT operation: %d\n", result4);

    // Bitwise left shift operation
    int result5 = num1 << 2;
    printf("Result of bitwise left shift operation: %d\n", result5);

    // Bitwise right shift operation
    int result6 = num1 >> 2;
    printf("Result of bitwise right shift operation: %d\n", result6);

    char str[] = "hello";
    reverse_string(str);
    printf("Reversed string: %s\n", str);

    return 0;
}