//Gemma-7B DATASET v1.0 Category: Space Invaders Game Clone ; Style: all-encompassing
#include <stdio.h>
#include <stdlib.h>

#define LEFT 0
#define RIGHT 1
#define UP 2
#define DOWN 3

#define BORDER_SIZE 50

typedef struct invader {
  int x;
  int y;
  int direction;
} invader;

invader invaders[5];

void initializeInvaders() {
  for (int i = 0; i < 5; i++) {
    invaders[i].x = BORDER_SIZE / 2 - 10 + i;
    invaders[i].y = BORDER_SIZE - 1;
    invaders[i].direction = RIGHT;
  }
}

void moveInvaders() {
  for (int i = 0; i < 5; i++) {
    switch (invaders[i].direction) {
      case LEFT:
        invaders[i].x--;
        break;
      case RIGHT:
        invaders[i].x++;
        break;
      case UP:
        invaders[i].y--;
        break;
      case DOWN:
        invaders[i].y++;
        break;
    }

    if (invaders[i].x < 0) {
      invaders[i].direction = RIGHT;
    } else if (invaders[i].x >= BORDER_SIZE - 1) {
      invaders[i].direction = LEFT;
    }

    if (invaders[i].y < 0) {
      invaders[i].direction = DOWN;
    } else if (invaders[i].y >= BORDER_SIZE - 1) {
      invaders[i].direction = UP;
    }
  }
}

void drawInvaders() {
  for (int i = 0; i < 5; i++) {
    printf("%c ", invaders[i].x + 1, invaders[i].y + 1);
  }
  printf("\n");
}

int main() {
  initializeInvaders();

  for (int i = 0; i < 10; i++) {
    moveInvaders();
    drawInvaders();
  }

  return 0;
}