//Falcon-180B DATASET v1.0 Category: Personal Finance Planner ; Style: Sherlock Holmes
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

struct Expense {
    char description[50];
    double amount;
    time_t date;
};

struct Account {
    char name[50];
    double balance;
};

void addExpense(struct Account* account, struct Expense expense) {
    account->balance -= expense.amount;
    printf("Added expense: %s - $%.2f\n", expense.description, expense.amount);
}

void deposit(struct Account* account, double amount) {
    account->balance += amount;
    printf("Deposited: $%.2f\n", amount);
}

void withdraw(struct Account* account, double amount) {
    if (account->balance >= amount) {
        account->balance -= amount;
        printf("Withdrew: $%.2f\n", amount);
    } else {
        printf("Insufficient funds.\n");
    }
}

void viewTransactions(struct Account* account) {
    printf("Transactions:\n");
    for (int i = 0; i < 10; i++) {
        time_t now = time(NULL);
        struct tm* tm = localtime(&now);
        char date[20];
        strftime(date, 20, "%m/%d/%Y", tm);
        printf("On %s: ", date);
        if (i < account->balance) {
            printf("Withdrew: $%.2f\n", account->balance - i);
        } else {
            printf("Deposited: $%.2f\n", i - account->balance);
        }
    }
}

int main() {
    struct Account account = {"Sherlock Holmes", 1000};
    struct Expense expense = {"Rent", 500, time(NULL)};
    addExpense(&account, expense);
    deposit(&account, 200);
    withdraw(&account, 300);
    viewTransactions(&account);
    return 0;
}