//Falcon-180B DATASET v1.0 Category: Phone Book ; Style: random
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the maximum number of contacts
#define MAX_CONTACTS 100

// Define the contact structure
typedef struct {
    char name[50];
    char phone[20];
} contact_t;

// Function to add a new contact to the phone book
void add_contact(contact_t *phone_book, int num_contacts, char *name, char *phone) {
    if (num_contacts >= MAX_CONTACTS) {
        printf("Phone book is full. Cannot add new contact.\n");
        return;
    }

    // Copy the name and phone number to the phone book
    strcpy(phone_book[num_contacts].name, name);
    strcpy(phone_book[num_contacts].phone, phone);

    // Increment the number of contacts
    num_contacts++;
}

// Function to search for a contact in the phone book
int search_contact(contact_t *phone_book, int num_contacts, char *name) {
    int i;

    // Search for the contact
    for (i = 0; i < num_contacts; i++) {
        if (strcmp(phone_book[i].name, name) == 0) {
            // Contact found, return its index
            return i;
        }
    }

    // Contact not found, return -1
    return -1;
}

// Function to display the phone book
void display_phone_book(contact_t *phone_book, int num_contacts) {
    int i;

    // Display the phone book
    printf("Phone Book:\n");
    for (i = 0; i < num_contacts; i++) {
        printf("%d. %s - %s\n", i+1, phone_book[i].name, phone_book[i].phone);
    }
}

// Main function
int main() {
    int num_contacts = 0;
    contact_t phone_book[MAX_CONTACTS];

    // Initialize the phone book
    memset(phone_book, 0, sizeof(phone_book));

    // Example usage
    add_contact(phone_book, num_contacts, "John Doe", "123-456-7890");
    add_contact(phone_book, num_contacts, "Jane Doe", "987-654-3210");
    add_contact(phone_book, num_contacts, "Bob Smith", "555-555-5555");

    // Display the phone book
    display_phone_book(phone_book, num_contacts);

    // Search for a contact
    int index = search_contact(phone_book, num_contacts, "Bob Smith");
    if (index!= -1) {
        printf("Contact found at index %d:\n", index);
        printf("%s - %s\n", phone_book[index].name, phone_book[index].phone);
    } else {
        printf("Contact not found.\n");
    }

    return 0;
}