//LLAMA2-13B DATASET v1.0 Category: Ebook reader ; Style: random
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <math.h>

#define BOOK_TITLE_MAX_LENGTH 50
#define CHAPTER_TITLE_MAX_LENGTH 20
#define PARAGRAPH_MAX_LENGTH 100

typedef struct {
    char title[BOOK_TITLE_MAX_LENGTH];
    char chapter_titles[ CHAPTER_TITLE_MAX_LENGTH][CHAPTER_TITLE_MAX_LENGTH];
    char paragraphs[PARAGRAPH_MAX_LENGTH][PARAGRAPH_MAX_LENGTH];
} Book;

Book *create_book(void) {
    Book *book = malloc(sizeof(Book));

    // Generate a random book title
    sprintf(book->title, "The %s Adventure", rand() % 10);

    // Generate random chapter titles
    for (int i = 0; i < 10; i++) {
        sprintf(book->chapter_titles[i], "Chapter %d: The %s Quest", i + 1, rand() % 10);
    }

    // Generate random paragraphs
    for (int i = 0; i < 100; i++) {
        sprintf(book->paragraphs[i], "Page %d: The %s %s the %s %s", i + 1, rand() % 10, rand() % 10, rand() % 10, rand() % 10);
    }

    return book;
}

void display_book(Book *book) {
    printf("Book Title: %s\n", book->title);
    for (int i = 0; i < 10; i++) {
        printf("Chapter %d: %s\n", i + 1, book->chapter_titles[i]);
    }
    for (int i = 0; i < 100; i++) {
        printf("Page %d: %s\n", i + 1, book->paragraphs[i]);
    }
}

int main(void) {
    Book *book = create_book();
    display_book(book);
    free(book);
    return 0;
}