//LLAMA2-13B DATASET v1.0 Category: Client Server Application ; Style: scientific
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define PORT 8888

struct particle {
    int id;
    float x;
    float y;
    float z;
};

int main(int argc, char *argv[]) {
    int sock;
    struct particle particles[10];
    int i;

    // Create a socket
    sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock < 0) {
        perror("socket creation failed");
        exit(EXIT_FAILURE);
    }

    // Set up the server
    struct sockaddr_in server_addr;
    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(PORT);
    inet_pton(AF_INET, "127.0.0.1", &server_addr.sin_addr);

    // Connect to the server
    if (connect(sock, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0) {
        perror("connect failed");
        exit(EXIT_FAILURE);
    }

    // Send the number of particles
    send(sock, &particles[0].id, sizeof(particles[0].id), 0);

    // Receive the particles from the server
    for (i = 0; i < 10; i++) {
        recv(sock, &particles[i], sizeof(particles[i]), 0);
    }

    // Print the received particles
    for (i = 0; i < 10; i++) {
        printf("Particle %d: (%.2f, %.2f, %.2f)\n", particles[i].id, particles[i].x, particles[i].y, particles[i].z);
    }

    // Close the socket
    close(sock);

    return 0;
}