//Gemma-7B DATASET v1.0 Category: Tic Tac Toe AI ; Style: multivariable
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define BOARD_SIZE 3

int main()
{
    int board[BOARD_SIZE][BOARD_SIZE] = {{0, 0, 0},
                                {0, 0, 0},
                                {0, 0, 0}};

    int player = 1;
    int move_made = 0;

    // Seed the random number generator
    srand(time(NULL));

    // Loop until a winner is found or the board is full
    while (!move_made)
    {
        // Get the player's move
        int move_x = rand() % BOARD_SIZE;
        int move_y = rand() % BOARD_SIZE;

        // Check if the move is valid
        if (board[move_x][move_y] == 0)
        {
            // Make the move
            board[move_x][move_y] = player;

            // Increment the number of moves made
            move_made = 1;
        }
    }

    // Print the board
    for (int i = 0; i < BOARD_SIZE; i++)
    {
        for (int j = 0; j < BOARD_SIZE; j++)
        {
            printf("%d ", board[i][j]);
        }

        printf("\n");
    }

    // Print the winner or draw
    if (board[0][0] == player)
    {
        printf("Player %d won!\n", player);
    }
    else if (board[1][1] == player)
    {
        printf("Player %d won!\n", player);
    }
    else if (board[2][2] == player)
    {
        printf("Player %d won!\n", player);
    }
    else
    {
        printf("It's a draw.\n");
    }

    return 0;
}