//Falcon-180B DATASET v1.0 Category: Error handling ; Style: expert-level
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>

#define MAX_ERRORS 10

typedef struct {
    char *message;
    int line_number;
} Error;

Error errors[MAX_ERRORS];
int num_errors = 0;

void add_error(const char *message, int line_number) {
    if (num_errors >= MAX_ERRORS) {
        fprintf(stderr, "Error: Too many errors\n");
        exit(1);
    }

    errors[num_errors].message = strdup(message);
    errors[num_errors].line_number = line_number;

    num_errors++;
}

void print_errors() {
    if (num_errors == 0) {
        printf("No errors found\n");
        return;
    }

    printf("Errors found:\n");
    for (int i = 0; i < num_errors; i++) {
        printf("Line %d: %s\n", errors[i].line_number, errors[i].message);
    }
}

int main() {
    int a = 10;
    int b = 20;
    int c = a + b;

    if (c!= 30) {
        add_error("Invalid calculation result", __LINE__);
    }

    if (a == b) {
        add_error("a and b cannot be equal", __LINE__);
    }

    char *str = "Hello, world!";
    char *ptr = strstr(str, "world");

    if (ptr == NULL) {
        add_error("String not found", __LINE__);
    }

    return 0;
}