//Falcon-180B DATASET v1.0 Category: Interprocess communication ; Style: distributed
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#define BUFFER_SIZE 1024

void die(const char *s) {
    perror(s);
    exit(EXIT_FAILURE);
}

int main(int argc, char **argv) {
    int server_socket, client_socket;
    struct sockaddr_in server_addr, client_addr;
    socklen_t client_size;
    char buffer[BUFFER_SIZE];
    int opt = 1;
    int addrlen = sizeof(client_addr);

    // Create socket
    if ((server_socket = socket(AF_INET, SOCK_STREAM, 0)) == 0)
        die("socket failed");

    // Set options on the socket
    if (setsockopt(server_socket, SOL_SOCKET, SO_REUSEADDR | SO_REUSEPORT, &opt, sizeof(opt)))
        die("setsockopt");

    server_addr.sin_family = AF_INET;
    server_addr.sin_addr.s_addr = INADDR_ANY;
    server_addr.sin_port = htons(8080);

    // Bind the socket
    if (bind(server_socket, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0)
        die("bind failed");

    // Listen for incoming connections
    if (listen(server_socket, 3) < 0)
        die("listen");

    while (1) {
        // Accept a connection
        if ((client_socket = accept(server_socket, (struct sockaddr *)&client_addr, &addrlen)) < 0)
            die("accept");

        printf("Connection from %s\n", inet_ntoa(client_addr.sin_addr));

        // Duplicate the socket for the child process
        if ((dup(client_socket)) < 0)
            die("dup");

        // Close the original socket
        if (close(server_socket) < 0)
            die("close");

        // Execute child process
        execlp("child_process", "child_process", NULL);
        die("execlp");
    }

    return 0;
}