//LLAMA2-13B DATASET v1.0 Category: Networking ; Style: synchronous
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define PORT 8080

int main(int argc, char *argv[]) {
    int sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock < 0) {
        perror("socket creation failed");
        exit(EXIT_FAILURE);
    }

    struct sockaddr_in server_addr = {
        .sin_family = AF_INET,
        .sin_port = htons(PORT),
        .sin_addr.s_addr = inet_addr("127.0.0.1")
    };

    if (connect(sock, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0) {
        perror("connect failed");
        exit(EXIT_FAILURE);
    }

    char buff[256];
    int recv_len = recv(sock, buff, 256, 0);
    if (recv_len < 0) {
        perror("recv failed");
        exit(EXIT_FAILURE);
    }

    printf("Received message: %s\n", buff);

    char *message = "Hello, server!";
    send(sock, message, strlen(message), 0);

    char *input = "Hello, client!";
    recv_len = recv(sock, buff, 256, 0);
    if (recv_len < 0) {
        perror("recv failed");
        exit(EXIT_FAILURE);
    }

    printf("Received message: %s\n", buff);

    close(sock);
    return 0;
}