//Falcon-180B DATASET v1.0 Category: Network Topology Mapper ; Style: curious
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_NODES 100
#define MAX_LINKS 200

typedef struct {
    char name[20];
    int id;
    int connected;
} Node;

typedef struct {
    int source;
    int destination;
    int status;
} Link;

Node nodes[MAX_NODES];
Link links[MAX_LINKS];

int num_nodes = 0;
int num_links = 0;

void add_node(char* name, int id) {
    strcpy(nodes[num_nodes].name, name);
    nodes[num_nodes].id = id;
    nodes[num_nodes].connected = 0;
    num_nodes++;
}

void add_link(int source, int destination, int status) {
    links[num_links].source = source;
    links[num_links].destination = destination;
    links[num_links].status = status;
    num_links++;
}

int main() {
    add_node("Computer A", 1);
    add_node("Computer B", 2);
    add_node("Computer C", 3);
    add_node("Computer D", 4);
    add_node("Computer E", 5);

    add_link(1, 2, 1);
    add_link(2, 3, 1);
    add_link(3, 4, 1);
    add_link(4, 5, 1);

    for (int i = 0; i < num_nodes; i++) {
        printf("Node %d: %s\n", nodes[i].id, nodes[i].name);
    }

    for (int i = 0; i < num_links; i++) {
        printf("Link %d: %d -> %d (status: %d)\n", i+1, links[i].source, links[i].destination, links[i].status);
    }

    return 0;
}