//Falcon-180B DATASET v1.0 Category: Queue Implementation ; Style: energetic
#include <stdio.h>
#include <stdlib.h>

#define MAX 100

//node structure definition
struct node{
    int data;
    struct node* next;
};

//queue structure definition
struct queue{
    struct node* front;
    struct node* rear;
};

//function to create an empty queue
void createQueue(struct queue* q){
    q->front = q->rear = NULL;
}

//function to check if the queue is empty
int isEmpty(struct queue* q){
    return (q->front == NULL);
}

//function to check if the queue is full
int isFull(struct queue* q){
    struct node* temp = (struct node*)malloc(sizeof(struct node));
    if(temp == NULL){
        return 1;
    }
    free(temp);
    return 0;
}

//function to add an element to the rear of the queue
void enqueue(struct queue* q, int data){
    struct node* temp = (struct node*)malloc(sizeof(struct node));
    if(temp == NULL){
        printf("Queue is full\n");
        return;
    }
    temp->data = data;
    temp->next = NULL;
    if(isEmpty(q)){
        q->front = temp;
        q->rear = temp;
    }
    else{
        q->rear->next = temp;
        q->rear = temp;
    }
}

//function to remove an element from the front of the queue
void dequeue(struct queue* q){
    struct node* temp = q->front;
    if(isEmpty(q)){
        printf("Queue is empty\n");
        return;
    }
    if(q->front == q->rear){
        q->front = q->rear = NULL;
    }
    else{
        q->front = q->front->next;
    }
    free(temp);
}

//function to display the contents of the queue
void display(struct queue* q){
    struct node* temp = q->front;
    if(isEmpty(q)){
        printf("Queue is empty\n");
        return;
    }
    printf("Queue elements are: ");
    while(temp!= NULL){
        printf("%d ", temp->data);
        temp = temp->next;
    }
    printf("\n");
}

int main(){
    struct queue q;
    createQueue(&q);
    enqueue(&q, 10);
    enqueue(&q, 20);
    enqueue(&q, 30);
    display(&q);
    dequeue(&q);
    display(&q);
    dequeue(&q);
    display(&q);
    dequeue(&q);
    display(&q);
    return 0;
}