//Falcon-180B DATASET v1.0 Category: Warehouse Management System ; Style: cheerful
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_PRODUCTS 100
#define MAX_ORDERS 50

typedef struct {
    char name[50];
    int quantity;
    float price;
} Product;

typedef struct {
    int orderID;
    char customerName[50];
    int numProducts;
    Product products[MAX_PRODUCTS];
} Order;

void generateRandomOrder(Order *order) {
    srand(time(NULL));
    order->orderID = rand() % 1000;
    strcpy(order->customerName, "Customer");
    order->numProducts = rand() % 5 + 1;

    for (int i = 0; i < order->numProducts; i++) {
        Product product;
        strcpy(product.name, "Product");
        product.quantity = rand() % 10 + 1;
        product.price = rand() % 100 + 1;
        order->products[i] = product;
    }
}

void printOrder(Order order) {
    printf("Order ID: %d\n", order.orderID);
    printf("Customer Name: %s\n", order.customerName);
    printf("Number of Products: %d\n", order.numProducts);

    for (int i = 0; i < order.numProducts; i++) {
        printf("Product %d:\n", i + 1);
        printf("Name: %s\n", order.products[i].name);
        printf("Quantity: %d\n", order.products[i].quantity);
        printf("Price: $%.2f\n\n", order.products[i].price);
    }
}

int main() {
    Order order;
    generateRandomOrder(&order);
    printOrder(order);

    return 0;
}