//LLAMA2-13B DATASET v1.0 Category: Bitwise operations ; Style: calm
#include <stdio.h>

int main() {
    int age = 25;
    int height = 175;
    int weight = 65;

    // Bitwise AND
    int result = age & 0b11010110;
    printf("Age in binary: %b\n", age);
    printf("Result of AND: %b\n", result);

    // Bitwise OR
    result = age | 0b10100101;
    printf("Age in binary: %b\n", age);
    printf("Result of OR: %b\n", result);

    // Bitwise XOR
    result = age ^ 0b10101010;
    printf("Age in binary: %b\n", age);
    printf("Result of XOR: %b\n", result);

    // Bitwise NOT
    result = ~age;
    printf("Age in binary: %b\n", age);
    printf("Result of NOT: %b\n", result);

    // Shift Left
    result = age << 2;
    printf("Age in binary: %b\n", age);
    printf("Result of Shift Left: %b\n", result);

    // Shift Right
    result = age >> 2;
    printf("Age in binary: %b\n", age);
    printf("Result of Shift Right: %b\n", result);

    // Bitwise AND with Bitfields
    union {
        int i;
        struct {
            unsigned char a:1;
            unsigned char b:1;
            unsigned char c:1;
        } s;
    } u;

    u.s.a = 1;
    u.s.b = 1;
    u.s.c = 1;

    result = u.i & 0b11010110;
    printf("Bitfield in binary: %b\n", u.s);
    printf("Result of AND: %b\n", result);

    return 0;
}