//GEMINI-pro DATASET v1.0 Category: URL Sanitizer ; Style: systematic
#include <curl/curl.h>
#include <stdio.h>
#include <stdlib.h>

// Custom callback to sanitize URLs.
size_t sanitize_callback(char *ptr, size_t size, size_t nmemb, void *userp) {
  CURLU *url = (CURLU *)userp;
  char *sanitized_url = curl_easy_unescape(url, ptr, (size * nmemb), NULL);
  if (!sanitized_url) {
    return 0;
  }
  fwrite(sanitized_url, sizeof(char), strlen(sanitized_url), stdout);
  curl_free(sanitized_url);
  return size * nmemb;
}

int main() {
  // Initialize the CURL library.
  curl_global_init(CURL_GLOBAL_ALL);

  // Create a CURL handle.
  CURL *curl = curl_easy_init();
  if (!curl) {
    return 1;
  }

  // Set the URL to sanitize.
  curl_easy_setopt(curl, CURLOPT_URL, "https://example.com/?q=<script>alert('XSS')</script>");

  // Create a CURLU handle for URL sanitization.
  CURLU *url = curl_url();
  if (!url) {
    curl_easy_cleanup(curl);
    return 2;
  }

  // Set the URL to sanitize.
  curl_url_set(url, CURLUPART_URL, "https://example.com/?q=<script>alert('XSS')</script>", 0);

  // Set the sanitize callback.
  curl_easy_setopt(curl, CURLOPT_WRITEDATA, url);
  curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, sanitize_callback);

  // Perform the URL sanitization.
  CURLcode res = curl_easy_perform(curl);
  if (res != CURLE_OK) {
    fprintf(stderr, "Error: %s\n", curl_easy_strerror(res));
    curl_easy_cleanup(curl);
    curl_url_cleanup(url);
    return 3;
  }

  // Cleanup.
  curl_easy_cleanup(curl);
  curl_url_cleanup(url);
  curl_global_cleanup();

  return 0;
}