//GEMINI-pro DATASET v1.0 Category: Dice Roller ; Style: real-life
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Define the number of sides for each die
#define NUM_SIDES 6

// Define the number of dice to roll
#define NUM_DICE 2

// Define the maximum possible roll for the given number of dice
#define MAX_ROLL (NUM_SIDES * NUM_DICE)

// Function to roll a single die
int roll_die(void) {
  return rand() % NUM_SIDES + 1;
}

// Function to roll multiple dice
int roll_dice(int num_dice) {
  int total = 0;
  for (int i = 0; i < num_dice; i++) {
    total += roll_die();
  }
  return total;
}

// Function to print the results of a dice roll
void print_roll(int roll) {
  printf("You rolled a %d\n", roll);
}

// Function to play a simple dice game
void play_game(void) {
  // Seed the random number generator
  srand(time(NULL));

  // Roll the dice
  int roll = roll_dice(NUM_DICE);

  // Print the results of the roll
  print_roll(roll);

  // Check if the player won or lost
  if (roll == MAX_ROLL) {
    printf("You win!\n");
  } else {
    printf("You lose!\n");
  }
}

// Main function
int main(void) {
  // Play the game
  play_game();

  return 0;
}