//Gemma-7B DATASET v1.0 Category: Stock market tracker ; Style: Donald Knuth
#include <stdio.h>
#include <stdlib.h>

#define MAX_Stocks 10
#define MAX_Transactions 100

typedef struct Stock {
  char name[20];
  double currentPrice;
  double previousPrice;
  double change;
  int quantity;
} Stock;

typedef struct Transaction {
  char date[20];
  char time[20];
  Stock stock;
  double quantity;
  double pricePerShare;
  double totalCost;
} Transaction;

Stock stocks[MAX_Stocks];
Transaction transactions[MAX_Transactions];

void calculateChange(Stock *stock) {
  stock->change = (stock->currentPrice - stock->previousPrice) / stock->previousPrice * 100;
}

void calculateTotalCost(Transaction *transaction) {
  transaction->totalCost = transaction->quantity * transaction->pricePerShare;
}

int main() {
  int i, j;

  // Initialize stocks and transactions
  for (i = 0; i < MAX_Stocks; i++) {
    stocks[i].name[0] = '\0';
    stocks[i].currentPrice = 0.0;
    stocks[i].previousPrice = 0.0;
    stocks[i].change = 0.0;
    stocks[i].quantity = 0;
  }

  for (j = 0; j < MAX_Transactions; j++) {
    transactions[j].date[0] = '\0';
    transactions[j].time[0] = '\0';
    transactions[j].stock.name[0] = '\0';
    transactions[j].quantity = 0;
    transactions[j].pricePerShare = 0.0;
    transactions[j].totalCost = 0.0;
  }

  // Calculate changes for each stock
  for (i = 0; i < MAX_Stocks; i++) {
    calculateChange(&stocks[i]);
  }

  // Calculate total cost for each transaction
  for (j = 0; j < MAX_Transactions; j++) {
    calculateTotalCost(&transactions[j]);
  }

  // Print results
  for (i = 0; i < MAX_Stocks; i++) {
    printf("Stock: %s, Current Price: %.2lf, Previous Price: %.2lf, Change: %.2lf%, Quantity: %d\n", stocks[i].name, stocks[i].currentPrice, stocks[i].previousPrice, stocks[i].change, stocks[i].quantity);
  }

  for (j = 0; j < MAX_Transactions; j++) {
    printf("Transaction: Date: %s, Time: %s, Stock: %s, Quantity: %d, Price per Share: %.2lf, Total Cost: %.2lf\n", transactions[j].date, transactions[j].time, transactions[j].stock.name, transactions[j].quantity, transactions[j].pricePerShare, transactions[j].totalCost);
  }

  return 0;
}