//Gemma-7B DATASET v1.0 Category: Building a XML Parser ; Style: Donald Knuth
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef struct Node {
    char data;
    struct Node* next;
} Node;

typedef struct Parser {
    Node* head;
    char* xml_data;
    int pos;
    int state;
} Parser;

void parser_init(Parser* parser) {
    parser->head = NULL;
    parser->xml_data = NULL;
    parser->pos = 0;
    parser->state = 0;
}

void parser_parse(Parser* parser) {
    switch (parser->state) {
        case 0:
            if (parser->xml_data[parser->pos] == '<') {
                parser->state = 1;
            }
            break;
        case 1:
            if (parser->xml_data[parser->pos] == '>' && parser->head == NULL) {
                parser->state = 2;
                parser->head = malloc(sizeof(Node));
                parser->head->data = parser->xml_data[parser->pos - 1];
                parser->head->next = NULL;
            } else if (parser->xml_data[parser->pos] == '/') {
                parser->state = 0;
            } else {
                parser->state = 1;
            }
            break;
        case 2:
            if (parser->xml_data[parser->pos] == '>' && parser->head != NULL) {
                parser->state = 0;
                parser->head = parser->head->next;
            }
            break;
    }
}

int main() {
    Parser parser;
    parser_init(&parser);
    parser.xml_data = "<a><b><c>Test</c></b></a>";
    parser_parse(&parser);
    return 0;
}