//GEMINI-pro DATASET v1.0 Category: GPS Navigation Simulation ; Style: rigorous
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

// Define the Earth's radius in meters
#define EARTH_RADIUS 6371000

// Define the GPS accuracy in meters
#define GPS_ACCURACY 10

// Structure to represent a GPS coordinate
typedef struct {
    double latitude;
    double longitude;
    double altitude;
} GPSCoordinate;

// Function to calculate the distance between two GPS coordinates
double calculateDistance(GPSCoordinate coord1, GPSCoordinate coord2) {
    // Convert the coordinates to radians
    double lat1 = coord1.latitude * M_PI / 180;
    double lon1 = coord1.longitude * M_PI / 180;
    double lat2 = coord2.latitude * M_PI / 180;
    double lon2 = coord2.longitude * M_PI / 180;

    // Calculate the difference in latitude and longitude
    double dLat = lat2 - lat1;
    double dLon = lon2 - lon1;

    // Calculate the distance using the Haversine formula
    double a = pow(sin(dLat / 2), 2) + cos(lat1) * cos(lat2) * pow(sin(dLon / 2), 2);
    double c = 2 * atan2(sqrt(a), sqrt(1 - a));
    double distance = EARTH_RADIUS * c;

    return distance;
}

// Function to simulate GPS navigation
void simulateNavigation() {
    // Create a GPS coordinate for the starting point
    GPSCoordinate startCoord = {37.7749, -122.4194, 0};

    // Create a GPS coordinate for the destination
    GPSCoordinate destCoord = {37.7802, -122.4119, 0};

    // Calculate the distance between the starting point and the destination
    double distance = calculateDistance(startCoord, destCoord);

    // Simulate GPS updates by generating random coordinates within the GPS accuracy
    while (distance > GPS_ACCURACY) {
        // Generate a random latitude within the GPS accuracy
        double randomLat = startCoord.latitude + (2 * (rand() / (double)RAND_MAX) - 1) * GPS_ACCURACY;

        // Generate a random longitude within the GPS accuracy
        double randomLon = startCoord.longitude + (2 * (rand() / (double)RAND_MAX) - 1) * GPS_ACCURACY;

        // Create a GPS coordinate for the updated position
        GPSCoordinate updateCoord = {randomLat, randomLon, 0};

        // Calculate the distance between the updated position and the destination
        distance = calculateDistance(updateCoord, destCoord);

        // Print the updated position
        printf("Current position: %.6f, %.6f\n", updateCoord.latitude, updateCoord.longitude);
    }

    // Print the destination reached message
    printf("Destination reached!\n");
}

int main() {
    // Seed the random number generator
    srand(time(NULL));

    // Simulate GPS navigation
    simulateNavigation();

    return 0;
}