//Falcon-180B DATASET v1.0 Category: Website Uptime Monitor ; Style: distributed
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <curl/curl.h>
#include <pthread.h>
#include <time.h>

#define THREAD_COUNT 5
#define SLEEP_SECONDS 60

struct thread_data {
    char *url;
    int index;
};

void *monitor_thread(void *arg) {
    struct thread_data *data = (struct thread_data *) arg;
    char *url = data->url;
    int index = data->index;

    CURL *curl;
    CURLcode res;

    curl_global_init(CURL_GLOBAL_DEFAULT);
    curl = curl_easy_init();

    if(curl) {
        curl_easy_setopt(curl, CURLOPT_URL, url);
        curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, NULL);
        curl_easy_setopt(curl, CURLOPT_WRITEDATA, NULL);
        curl_easy_setopt(curl, CURLOPT_NOSIGNAL, 1L);
        curl_easy_setopt(curl, CURLOPT_TIMEOUT, 5L);
        curl_easy_setopt(curl, CURLOPT_CONNECTTIMEOUT, 5L);

        res = curl_easy_perform(curl);
        if(res!= CURLE_OK) {
            printf("Thread %d: Failed to connect to %s\n", index, url);
        } else {
            printf("Thread %d: %s is up\n", index, url);
        }

        curl_easy_cleanup(curl);
    } else {
        printf("Thread %d: Failed to initialize curl\n", index);
    }

    curl_global_cleanup();
    return NULL;
}

int main() {
    pthread_t threads[THREAD_COUNT];
    struct thread_data data[THREAD_COUNT];

    char *urls[] = {
        "http://www.google.com",
        "http://www.yahoo.com",
        "http://www.bing.com",
        "http://www.amazon.com",
        "http://www.facebook.com"
    };

    int i;
    for(i = 0; i < THREAD_COUNT; i++) {
        data[i].url = urls[i];
        data[i].index = i;
    }

    for(i = 0; i < THREAD_COUNT; i++) {
        pthread_create(&threads[i], NULL, monitor_thread, &data[i]);
    }

    for(i = 0; i < THREAD_COUNT; i++) {
        pthread_join(threads[i], NULL);
    }

    return 0;
}