//GEMINI-pro DATASET v1.0 Category: Stock market tracker ; Style: active
#include <stdio.h>
#include <stdlib.h>

// Data structure to store stock information
typedef struct Stock {
    char *name;
    double price;
    double volume;
} Stock;

// Function to compare two stocks based on their prices
int compareStocks(const void *a, const void *b) {
    const Stock *stock1 = (const Stock *)a;
    const Stock *stock2 = (const Stock *)b;
    return stock1->price - stock2->price;
}

// Function to print stock information
void printStock(const Stock *stock) {
    printf("Stock name: %s\n", stock->name);
    printf("Stock price: %.2f\n", stock->price);
    printf("Stock volume: %.2f\n\n", stock->volume);
}

// Function to track the stock market
void trackStockMarket() {
    // Create an array of stocks
    Stock stocks[] = {
        {"Apple", 120.00, 1000000.00},
        {"Microsoft", 90.00, 800000.00},
        {"Amazon", 150.00, 600000.00},
        {"Tesla", 200.00, 400000.00},
        {"Google", 130.00, 500000.00}
    };

    // Sort the stocks based on their prices
    qsort(stocks, sizeof(stocks) / sizeof(Stock), sizeof(Stock), compareStocks);

    // Print the sorted stocks
    printf("Sorted stocks:\n");
    for (int i = 0; i < sizeof(stocks) / sizeof(Stock); i++) {
        printStock(&stocks[i]);
    }
}

int main() {
    // Track the stock market
    trackStockMarket();
    return 0;
}