//GEMINI-pro DATASET v1.0 Category: Dice Roller ; Style: romantic
#include <stdio.h>
#include <time.h>

// Constants
#define MIN_DIE_VALUE 1
#define MAX_DIE_VALUE 6

// Structs
typedef struct {
    int value;
    char *name;
} DiceRoll;

// Function prototypes
DiceRoll rollDice();
void printRoll(DiceRoll roll);

int main() {
    // Seed the random number generator
    srand(time(NULL));

    // Roll the dice
    DiceRoll firstDie = rollDice();
    DiceRoll secondDie = rollDice();

    // Print the results
    printf("Your first roll is: ");
    printRoll(firstDie);

    printf("Your second roll is: ");
    printRoll(secondDie);

    // Determine the outcome
    int total = firstDie.value + secondDie.value;
    if (total == 7 || total == 11) {
        printf("You win!");
    } else if (total == 2 || total == 3 || total == 12) {
        printf("You lose!");
    } else {
        printf("You tie!");
    }

    return 0;
}

// Rolls a die and returns the result
DiceRoll rollDice() {
    DiceRoll roll;
    roll.value = (rand() % (MAX_DIE_VALUE - MIN_DIE_VALUE + 1)) + MIN_DIE_VALUE;
    switch (roll.value) {
        case 1:
            roll.name = "Ace";
            break;
        case 2:
            roll.name = "Deuce";
            break;
        case 3:
            roll.name = "Three";
            break;
        case 4:
            roll.name = "Four";
            break;
        case 5:
            roll.name = "Five";
            break;
        case 6:
            roll.name = "Six";
            break;
    }
    return roll;
}

// Prints the dice roll
void printRoll(DiceRoll roll) {
    printf("%s (%d)\n", roll.name, roll.value);
}

// Write a poem about dice rolling