//Falcon-180B DATASET v1.0 Category: Cryptography Implementation ; Style: single-threaded
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define KEY_SIZE 16
#define BLOCK_SIZE 8

void generate_key(unsigned char key[KEY_SIZE]) {
    int i;
    for (i = 0; i < KEY_SIZE; i++) {
        key[i] = rand() % 256;
    }
}

void encrypt(unsigned char plaintext[BLOCK_SIZE], unsigned char key[KEY_SIZE], unsigned char ciphertext[BLOCK_SIZE]) {
    int i;
    for (i = 0; i < BLOCK_SIZE; i++) {
        ciphertext[i] = plaintext[i] ^ key[i % KEY_SIZE];
    }
}

void decrypt(unsigned char ciphertext[BLOCK_SIZE], unsigned char key[KEY_SIZE], unsigned char plaintext[BLOCK_SIZE]) {
    int i;
    for (i = 0; i < BLOCK_SIZE; i++) {
        plaintext[i] = ciphertext[i] ^ key[i % KEY_SIZE];
    }
}

int main() {
    // Generate a key
    unsigned char key[KEY_SIZE];
    generate_key(key);

    // Plaintext to encrypt
    unsigned char plaintext[BLOCK_SIZE] = "Hello, world!";

    // Encrypt the plaintext
    unsigned char ciphertext[BLOCK_SIZE];
    encrypt(plaintext, key, ciphertext);

    // Print the ciphertext
    printf("Ciphertext: ");
    for (int i = 0; i < BLOCK_SIZE; i++) {
        printf("%02X ", ciphertext[i]);
    }
    printf("\n");

    // Decrypt the ciphertext
    unsigned char decrypted_text[BLOCK_SIZE];
    decrypt(ciphertext, key, decrypted_text);

    // Print the decrypted text
    printf("Decrypted text: %s\n", decrypted_text);

    return 0;
}