//GEMINI-pro DATASET v1.0 Category: Word Count Tool ; Style: relaxed
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// A brief guide to this program:
//
// - We'll start by reading the input file and counting the words.
// - Once we know how many words there are, we'll allocate a big enough array to store them.
// - Then we'll read the input file again and store the words in the array.
// - Finally, we'll sort the array and print out the word counts.

// First, let's define some constants and data structures.

#define MAX_WORDS 100000  // The maximum number of words we'll store.
#define MAX_WORD_LENGTH 100  // The maximum length of a word.

typedef struct {
  char word[MAX_WORD_LENGTH];  // The word itself.
  int count;  // How many times the word appears in the input file.
} WordCount;

// Now, let's define our functions.

// This function reads the input file and counts the words.

int count_words(FILE *fp) {
  int count = 0;  // The number of words in the input file.
  char buffer[MAX_WORD_LENGTH];  // A buffer for reading the input file.

  // Read the input file line by line.

  while (fgets(buffer, MAX_WORD_LENGTH, fp)) {
    // Split the line into words.

    char *word = strtok(buffer, " ");

    // Count the words.

    while (word != NULL) {
      count++;
      word = strtok(NULL, " ");
    }
  }

  // Return the number of words.

  return count;
}

// This function reads the input file again and stores the words in an array.

void read_words(FILE *fp, WordCount *words, int count) {
  char buffer[MAX_WORD_LENGTH];  // A buffer for reading the input file.
  int i = 0;  // The index of the current word.

  // Read the input file line by line.

  while (fgets(buffer, MAX_WORD_LENGTH, fp)) {
    // Split the line into words.

    char *word = strtok(buffer, " ");

    // Store the words in the array.

    while (word != NULL) {
      strcpy(words[i].word, word);
      words[i].count = 0;
      i++;
      word = strtok(NULL, " ");
    }
  }
}

// This function sorts the array of words.

void sort_words(WordCount *words, int count) {
  int i, j;  // Loop indices.

  // Bubble sort the words.

  for (i = 0; i < count; i++) {
    for (j = 0; j < count - 1; j++) {
      if (strcmp(words[j].word, words[j + 1].word) > 0) {
        WordCount temp = words[j];
        words[j] = words[j + 1];
        words[j + 1] = temp;
      }
    }
  }
}

// This function prints the word counts.

void print_word_counts(WordCount *words, int count) {
  int i;  // Loop index.

  // Print the word counts.

  for (i = 0; i < count; i++) {
    printf("%s: %d\n", words[i].word, words[i].count);
  }
}

// Now, let's put it all together in our main function.

int main() {
  // Open the input file.

  FILE *fp = fopen("input.txt", "r");
  if (fp == NULL) {
    fprintf(stderr, "Error: could not open input file.\n");
    exit(1);
  }

  // Count the words in the input file.

  int count = count_words(fp);

  // Allocate an array to store the words.

  WordCount *words = malloc(sizeof(WordCount) * count);
  if (words == NULL) {
    fprintf(stderr, "Error: could not allocate memory for words.\n");
    exit(1);
  }

  // Read the input file again and store the words in the array.

  rewind(fp);
  read_words(fp, words, count);

  // Sort the array of words.

  sort_words(words, count);

  // Print the word counts.

  print_word_counts(words, count);

  // Free the memory allocated for the words.

  free(words);

  // Close the input file.

  fclose(fp);

  return 0;
}